/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.field.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import dev.compactmods.crafting.util.MathUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class CraftingPreviewRenderer {
    public static void render(IMiniaturizationRecipe recipe, double progress, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        if (recipe == null) {
            return;
        }
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        try {
            double craftProgress = progress;
            double scale = MathUtil.calculateFieldScale(craftProgress + 3.0, recipe.getCraftingTime());
            stack.m_85841_((float)scale, (float)scale, (float)scale);
            long gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
            double angle = (double)gameTime % 360.0 * 2.0;
            stack.m_85845_(Vector3f.f_122225_.m_122240_((float)angle));
            AABB dimensions = recipe.getDimensions();
            stack.m_85837_(-(dimensions.m_82362_() / 2.0), -(dimensions.m_82376_() / 2.0), -(dimensions.m_82385_() / 2.0));
            double ySize = recipe.getDimensions().m_82376_();
            int y = 0;
            while ((double)y < ySize) {
                stack.m_85836_();
                stack.m_85837_(0.0, (double)y, 0.0);
                Optional<IRecipeLayer> layer = recipe.getLayer(y);
                int finalY = y++;
                layer.ifPresent(l -> {
                    AABB layerBounds = BlockSpaceUtil.getLayerBounds(recipe.getDimensions(), finalY);
                    BlockPos.m_121921_((AABB)layerBounds).forEach(filledPos -> {
                        stack.m_85836_();
                        stack.m_85837_((double)filledPos.m_123341_(), 0.0, (double)filledPos.m_123343_());
                        BlockPos zeroedPos = filledPos.m_6625_(finalY);
                        l.getComponentForPosition(zeroedPos).flatMap(recipe.getComponents()::getBlock).ifPresent(comp -> CraftingPreviewRenderer.renderSingleBlock(stack, buffers, blockRenderer, comp));
                        stack.m_85849_();
                    });
                });
                stack.m_85849_();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        stack.m_85849_();
    }

    private static void renderSingleBlock(PoseStack stack, MultiBufferSource buffers, BlockRenderDispatcher blockRenderer, IRecipeBlockComponent comp) {
        BlockState state1 = comp.getRenderState();
        Minecraft mc = Minecraft.m_91087_();
        blockRenderer.renderSingleBlock(state1, stack, buffers, 0xF00000, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
    }
}

